IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CP_Reserva_Producto') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE CP_Reserva_Producto
END
GO

CREATE PROCEDURE CP_Reserva_Producto	@pId_Producto VARCHAR(14)
AS
SET NOCOUNT ON

/*Declaracion Variables Locales*/

DECLARE @Mensaje			VARCHAR(100)
DECLARE @Reservado			INT
DECLARE @Fecha_Reserva		DATETIME

--1: Esta reservado (Nadie mas lo puede reservar)
--0: No estaba reservado y lo reserva

SET @Fecha_Reserva =  (SELECT ISNULL(Fecha_Reserva,'19900101') FROM Productos WHERE Id_Producto = @pId_Producto)

IF(@Fecha_Reserva >= DATEADD(MINUTE, -1 , GETDATE()))
BEGIN 
	SET @Reservado = 1
END 
ELSE
BEGIN
	UPDATE Productos 
	SET Fecha_Reserva = GETDATE()  
	WHERE 
	Id_Producto=@pId_Producto

	SET @Reservado = 0
END

SELECT @Reservado AS 'Reservado'